using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using cifXTest;
using System.Runtime.InteropServices;

namespace cifXTest
{
    public partial class cifXDeviceOPenDlg : Form
    {
        private cifXUser cifXUser = new cifXUser();

        public cifXDeviceOPenDlg()
        {
            InitializeComponent();
            EnumBoards();
            this.trvDevice.ExpandAll();
        }


        private void EnumBoards()
        {
            UInt32                          lret            = 0;
            UInt32                          iBoardCount     = 0;

            do
            {
                lret = cifXUser.xDriverEnumBoards(iBoardCount);
                if (lret == 0)
                {
                    //a valid board is found
                    TreeNodeAdd((int)iBoardCount);
                    iBoardCount++;
                }
            } while (lret == 0);
        }

        private void GetBoardInformation(UInt32 iBoardNumber)
        {
            UInt32                          lret        = 0;            
            lret = cifXUser.xDriverEnumBoards(iBoardNumber);
        }

        private void EnumChannels( UInt32 iBoardNumber )
        {
            UInt32                          lret            = 0;
            int                             iChannelcount   = 0;
            int                             MaxChannelCnt   = (int)cifXUser.BoardInformation.ulChannelCnt;

            for (iChannelcount = 0; iChannelcount < MaxChannelCnt; iChannelcount++)
            {
                lret = cifXUser.xDriverEnumChannels(iBoardNumber, (UInt32)iChannelcount);
            }
        }

        private void GetChannelInformation()
        {
            UInt32 lret = 0;
            lret = cifXUser.xChannelInfo();
        }

        private void TreeNodeAdd(int iBoardCount)
        {
            int MaxChannelCnt = (int)cifXUser.BoardInformation.ulChannelCnt;
            int iCnt = 0;
            TreeNode tnParent = new TreeNode();
            tnParent.Text = "cifX" + iBoardCount.ToString();
            for (iCnt = 0; iCnt < MaxChannelCnt; iCnt++)
            {
                tnParent.Nodes.Add("Channel" + iCnt.ToString());
            }
            this.trvDevice.Nodes.Add(tnParent);
        }

        private void FillList()
        {
            ListViewItem    lstItem         = new ListViewItem();
            string          sPhysicalAddress = string.Format("0x{0:X8}",cifXUser.BoardInformation.ulPhysicalAddress);
            this.lstInfo.BeginUpdate();
            this.lstInfo.Items.Clear();

            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Physical Address" ,
                                                                    sPhysicalAddress}));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Interrupt" ,
                                                                    cifXUser.BoardInformation.ulIrqNumber.ToString()}));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Device Number" ,
                                                                    cifXUser.BoardInformation.tSystemInfo.ulDeviceNumber.ToString()}));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Serial Number" ,
                                                                    cifXUser.BoardInformation.tSystemInfo.ulSerialNumber.ToString()}));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "DPM Size" ,
                                                                    cifXUser.BoardInformation.ulDpmTotalSize.ToString()}));            
            this.lstInfo.EndUpdate();
        }

        private void FillSubList()
        {
            string sFWVersion = string.Format("{0:d}.{1:d}.{3:d}.{2:d} (Build {3:d})",
                                                                    cifXUser.ChannelInformation.usFWMajor,
                                                                    cifXUser.ChannelInformation.usFWMinor,
                                                                    cifXUser.ChannelInformation.usFWRevision,
                                                                    cifXUser.ChannelInformation.usFWBuild);
            string sFWDate      = string.Format("{1:d}/{0:d}/{2:d}",
                                                                    cifXUser.ChannelInformation.bFWDay,
                                                                    cifXUser.ChannelInformation.bFWMonth,
                                                                    cifXUser.ChannelInformation.usFWYear);            

            this.lstInfo.BeginUpdate();

            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Firmware Name" ,
                                                                    ByteArrayToString(cifXUser.ChannelInformation.abFWName)}));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Firmware Version" , sFWVersion }));
            this.lstInfo.Items.Add(new ListViewItem(new string[] { "Firmware Date" , sFWDate }));
                                                    
            this.lstInfo.EndUpdate();
        }

        private void trvDevice_AfterSelect(object sender, TreeViewEventArgs e)
        {
            //a valid board is selected to show the board information
            int                             iBoard              = -1;
            int                             iChannel            = -1;
            string                          sBoardName          = "";

            if (e.Node.Text.StartsWith("Channel"))
            {
                iBoard      = Int32.Parse(e.Node.Parent.Text.Substring(e.Node.Parent.Text.Length - 1));
                sBoardName  = e.Node.Parent.Text;
                iChannel    = Int32.Parse(e.Node.Text.Substring(e.Node.Text.Length - 1));
            }
            else
                iBoard = Int32.Parse(e.Node.Text.Substring((e.Node.Text.Length - 1)));

            GetBoardInformation((UInt32)iBoard);
            FillList();
            if (iChannel != -1)
            {
                UInt32 lret = 0;
                lret = cifXUser.xChannelOpen(sBoardName, iChannel);
                if (lret == 0)
                {
                    cifXUser.ActiveChannel = iChannel;
                    GetChannelInformation();
                    FillSubList();
                }
            }
        }
        private byte[] StringToByteArray(string str)
        {
            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            return enc.GetBytes(str);
        }

        private string ByteArrayToString(byte[] arr)
        {
            System.Text.ASCIIEncoding enc = new System.Text.ASCIIEncoding();
            return enc.GetString(arr);
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            string sTreeNodeSelected    = this.trvDevice.SelectedNode.Text;
            string sTreeNodeParent      = null;
            if(this.trvDevice.SelectedNode.Parent != null)
                sTreeNodeParent      = this.trvDevice.SelectedNode.Parent.Text;

            UInt32 lret                 = 0;

            if (sTreeNodeParent != null)
            {
                //a subnode is selected (channel), so you have to call the xChannelOpen function
                int iChannel = Int32.Parse(sTreeNodeSelected.Substring(sTreeNodeSelected.Length - 1));
                //Open the Sysdevice to get the handle
                lret = cifXUser.xSysdeviceOpen(sTreeNodeParent);
                //Open the channel to get the handle
                lret = cifXUser.xChannelOpen(sTreeNodeParent, iChannel);
                if (lret == 0)
                {
                    //The channel is succesfully opened. The channel Number will be stored in ActiveChannel
                    cifXUser.ActiveChannel  = iChannel;
                    cifXUser.ActiveBoard    = sTreeNodeParent;
                    MdiParent.Text = "cifX Test Application for C# " + cifXUser.ActiveBoard.ToString() + " Channel" + cifXUser.ActiveChannel.ToString();
                }
                this.Close();
            }
            else
            {
                //a parent node is selected (device), so you have to call the xSysdeviceOpen function
                lret = cifXUser.xSysdeviceOpen(sTreeNodeSelected);
                if (lret == 0)
                {
                    cifXUser.ActiveChannel = 0;
                    cifXUser.hChannel = 0;
                    cifXUser.ActiveBoard = sTreeNodeSelected;
                    MdiParent.Text = "cifX Test Application for C# " + sTreeNodeSelected;
                }
                this.Close();
            }
        }

    }
}